% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{zb_color}
\alias{zb_color}
\title{Generate colors for zones}
\usage{
zb_color(z, palette = c("rings", "hcl", "dartboard"))
}
\arguments{
\item{z}{An `sf` object containing zones covering the region}

\item{palette}{Palette type, one of \code{"hcl"} (a palette based on the HCL color space), \code{"rings"} (a palette which colors the rings using the YlOrBr color brewer palette), \code{"dartboard"} (a palette which resembles a dartboard)}
}
\value{
A vector of colors
}
\description{
This function generates colors for zones.
}
\examples{
z = zb_zone(london_c(), london_a())
zb_color(z)
plot(z[, "circle_id"], col = zb_color(z))
}
