% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{fit_zoid}
\alias{fit_zoid}
\title{Fit a Bayesian Dirichlet regression model, allowing for zero-and-one inflation, covariates, and overdispersion}
\usage{
fit_zoid(
  formula = NULL,
  design_matrix,
  data_matrix,
  chains = 3,
  iter = 2000,
  warmup = floor(iter/2),
  overdispersion = FALSE,
  overdispersion_sd = 5,
  posterior_predict = FALSE,
  moment_match = FALSE,
  prior_sd = NA,
  ...
)
}
\arguments{
\item{formula}{The model formula for the design matrix. Does not need to have a response specified. If =NULL, then
the design matrix is ignored and all rows are treated as replicates}

\item{design_matrix}{A data frame, dimensioned as number of observations, and covariates in columns}

\item{data_matrix}{A matrix, with observations on rows and number of groups across columns}

\item{chains}{Number of mcmc chains, defaults to 3}

\item{iter}{Number of mcmc iterations, defaults to 2000}

\item{warmup}{Number iterations for mcmc warmup, defaults to 1/2 of the iterations}

\item{overdispersion}{Whether or not to include overdispersion parameter, defaults to FALSE}

\item{overdispersion_sd}{Prior standard deviation on 1/overdispersion parameter, Defaults to inv-Cauchy(0,5)}

\item{posterior_predict}{Whether or not to return draws from posterior predictive distribution (requires more memory)}

\item{moment_match}{Whether to do moment matching via \code{\link[loo:loo_moment_match]{loo::loo_moment_match()}}. This increases memory by adding all temporary
parmaeters to be saved and returned}

\item{prior_sd}{Parameter to be passed in to use as standard deviation of the normal distribution in transformed space. If
covariates are included this defaults to 1, but for models with single replicate, defaults to 1/n_bins.}

\item{...}{Any other arguments to pass to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\value{
A list containing the fitted model and arguments and data used
to fit the model. These include \code{model} (the fitted model object of class \code{stanfit}),
\code{par_names} (the names of monitored parameters), \code{design_matrix} (the
design matrix of covariates), \code{data_matrix} (the data matrix of responses),
\code{overdispersion} (boolean, whether overdispersion was used),
\code{overdispersion_prior} (the prior used for overdispersion),
and \code{posterior_predict} (boolean, whether posterior prediction was done)
}
\description{
Fit a Bayesian Dirichlet regression model that optionally includes covariates to estimate
effects of factor or continuous variables on proportions.
}
\examples{
\donttest{
y <- matrix(c(3.77, 6.63, 2.60, 0.9, 1.44, 0.66, 2.10, 3.57, 1.33),
  nrow = 3, byrow = TRUE
)
# fit a model with no covariates
fit <- fit_zoid(data_matrix = y)

# fit a model with 1 factor
design <- data.frame("y" = c(1, 1, 1), "fac" = c("spring", "spring", "fall"))
fit <- fit_zoid(formula = ~fac, design_matrix = design, data_matrix = y)
}

}
