% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_lm.R
\name{zlm}
\alias{zlm}
\title{Run an lm model in a pipe.}
\usage{
zlm(
  data,
  formula,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the model data.}

\item{formula}{The \code{formula} to be fitted.}

\item{subset}{See the \code{lm} function.}

\item{weights}{See the \code{lm} function.}

\item{na.action}{See the \code{lm} function.}

\item{method}{See the \code{lm} function.}

\item{model}{See the \code{lm} function.}

\item{x}{See the \code{lm} function.}

\item{y}{See the \code{lm} function.}

\item{qr}{See the \code{lm} function.}

\item{singular.ok}{See the \code{lm} function.}

\item{contrasts}{See the \code{lm} function.}

\item{offset}{See the \code{lm} function.}

\item{...}{Other arguments to be passed to the \code{lm} function.}
}
\value{
A fitted model.
}
\description{
This function wraps around the \link{lm} function in order to make it
more friendly to pipe syntax (with the data first).
}
\examples{

# Usage is possible without pipes
zlm( cars, dist ~ speed )

# zfit works well with dplyr
if ( require("dplyr", warn.conflicts=FALSE) ) {

  # Pipe cars dataset into zlm for fitting
  cars \%>\% zlm( speed ~ dist )

  # Process iris with filter before piping to zlm
  iris \%>\%
    filter(Species=="setosa") \%>\%
    zlm(Sepal.Length ~ Sepal.Width + Petal.Width)
}

# zfit also works well with the native pipe
if ( getRversion() >= "4.1.0" ) {

  # Pipe cars dataset into zlm for fitting
  cars |> zlm( speed ~ dist )

  # Extremely naive filtering function for piped usage
  filter_naive <- function(data, column, value) {
    data[data[,column]==value,]
  }

  # Process iris with filter() before piping. Print a summary()
  # of the fitted model using zprint() before assigning the
  # model itself (not the summary) to m
  m <- iris |>
    filter_naive("Species","setosa") |>
    zlm(Sepal.Length ~ Sepal.Width + Petal.Width) |>
    zprint(summary)
}

}
\seealso{
\itemize{
\item \link{zglm} is a wrapper for \code{glm}, to fit generalized
linear models.
}
}
