% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{rescale.min.dist}
\alias{rescale.min.dist}
\title{Rescaling of data based on the minimum distance between sites}
\usage{
rescale.min.dist(xy, data.spec, data.env = NULL, m,
  distance.type = "Euclidean", dist.custom = NULL, method = "mean",
  shuffle = FALSE)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Site-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{m}{Mapping grain (the number of sites combined to generate data at a coarser grain). The \code{m} closest sites are grouped together.}

\item{distance.type}{Method to compute distance. Default is "\code{Euclidean}", for Euclidean distance. The other options are (i) "\code{ortho}" for orthodromic distance, if xy correspond to longitudes and latitudes (orthodromic distance is computed using the \code{gdist} function from package \code{Imap}); and (ii) "\code{custom}", in which case the user must provide a distance matrix for \code{dist.custom}.}

\item{dist.custom}{Distance matrix provided by the user when \code{distance.type} = \code{"custom"}.}

\item{method}{Name of a function (as a string) indicating how to combine the coordinates and the environmental variables. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{shuffle}{Boolean value (TRUE or FALSE) indicating if the order of the sites must be randomised, which can have an impact on the outputs if some distances are equal.}
}
\value{
\code{rescale.min.dist} returns a data frame with the rescaled data.
}
\description{
Combines sites based on the minimum distance between them.
}
\details{
The nearest neighbouring sites (plots, quadrates, or areas of varying shapes) are grouped as spatial clusters of 2, 3, 4, etc. sites, based on the minimum distance between them. Since the procedure is based on the relative distance between sites, the site order can have an impact on the output. This function is suitable for both regularly and irregularly spaced sites, contiguous or non contiguous. For regularly spaced sites, the use of \code{\link{rescale.regular}} is recommended.
}
\examples{
utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

data.rescale <- rescale.min.dist(xy.marion, data.spec.marion, m=2)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}},

\code{\link{Zeta.scale.min.dist}}, \code{\link{Zeta.scale.regular}}, \code{\link{rescale.regular}}
}
