% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zerotradeflow.R
\docType{data}
\name{distinct}
\alias{distinct}
\title{Dataset composed of six different countries.}
\format{
A dataframe object.
}
\usage{
distinct
}
\value{
a dataframe object contains the five variables passed as parameters
to the get_zerotradeflow() function (year, exporter, importer, item, trade)
including the bilateral trade flow equal to zero.
}
\description{
A dummy dataset to illustrate the final size of the base after
expansion.
}
\details{
A dataset consisting of three years, three exporting countries,
three importing countries, three Harmonized System code and value of
exports (all data is fictitious). The data includes the following fields:

* ano - Numeric. Year in which exports were carried out.
* ido - String. ISO code corresponding to the exporting country.
* idd - String. ISO code corresponding to the importign country.
* HS4 - Numeric. HS4 code corresponding to the merchandise sold.
* comercio - Numeric. Dollar value of exports.
}
\examples{

# Note that the distinct.rda base has six different countries (three
# exporters and three importers). Thus, when expanding this base, we have 81
# observations as a result.


\donttest{

distinctflow <- get_zerotradeflow(distinct, ano, ido, idd, HS4, comercio)

}


}
\keyword{datasets}
