% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{local_association}
\alias{local_association}
\alias{lewontin_d}
\alias{duchers_z}
\alias{pmi}
\alias{chisq}
\title{Local Association Measures}
\usage{
local_association(x, measure = "chisq", nr = 1)

lewontin_d(x)

duchers_z(x)

pmi(x, normalize)

chisq(x, nr)
}
\arguments{
\item{x}{list of probabilities as outputted by \code{\link[zebu]{estimate_prob}}.}

\item{measure}{name of measure to be used:
\itemize{
\item'chisq': Chi-squared residuals.
\item'd': Lewontin's D.
\item'z': Ducher's 'z'.
\item'pmi': Pointwise mutual information (in bits).
\item'npmi': Normalized pointwise mutual information (Bouma).
\item'npmi2': Normalized pointwise mutual information (Multivariate).
}}

\item{nr}{number of rows/samples. Only used to estimate chi-squared residuals.}

\item{normalize}{0 for pmi, 1 for npmi, 2 for npmi2}
}
\value{
List containing the following values:
\itemize{
\item local: local association array (may contain NA, NaN and Inf values).
\item global: global association numeric value.
}
}
\description{
Subroutines called by \code{\link[zebu]{lassie}} to compute
local and global association measures from a list of probabilities.
}
\examples{
# This is what happens behind the curtains in the 'lassie' function
# Here we compute the association between the 'Girth' and 'Height' variables
# of the 'trees' dataset

# 'select' and 'continuous' take column numbers or names
select <- c('Girth', 'Height') # select subset of trees
continuous <-c(1, 2) # both 'Girth' and 'Height' are continuous

# equal-width discretization with 3 bins
breaks <- 3

# Preprocess data: subset, discretize and remove missing data
pre <- preprocess(trees, select, continuous, breaks)

# Estimates marginal and multivariate probabilities from preprocessed data.frame
prob <- estimate_prob(pre$pp)

# Computes local and global association using Ducher's Z
lam <- local_association(prob, measure = 'z')
}
\seealso{
\code{\link[zebu]{lassie}}
}
