% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Standing-Katz.R
\name{multiplotStandingKatz}
\alias{multiplotStandingKatz}
\title{Plot multiple Tpr isotherm curves in one figure}
\usage{
multiplotStandingKatz(tpr = NULL, pprRange = "lp", ...)
}
\arguments{
\item{tpr}{a vector of one of multiple Pseudo-reduced temperatures}

\item{pprRange}{Takes one of two values: "lp": low pressure, or "hp".
Default: "lp"}

\item{...}{additional parameters}
}
\description{
Plot shows the digitized isotherm of the Standing-Katz chart
}
\examples{
# plot Standing-Katz curves for Tpr=1.1 and 2.0
multiplotStandingKatz(c(1.1, 2))

# plot SK curves for the lowest range of Tpr
multiplotStandingKatz(c(1.05, 1.1, 1.2))
}
