% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json-opts.R
\docType{data}
\name{yyjson_write_flag}
\alias{yyjson_write_flag}
\title{Advanced: Values for setting internal options directly on YYJSON library}
\format{
An object of class \code{list} of length 8.
}
\usage{
yyjson_write_flag
}
\description{
This is a list of integer values used for setting flags on the \code{yyjson}
code directly.  This is an ADVANCED option and should be used with caution.
}
\details{
Some of these settings overlap and conflict with code needed to handle
the translation of JSON values to R.

\code{opts_write_json(yyjson_write_flag = c(write_flag$x, write_flag$y, ...))}

\describe{
\item{YYJSON_WRITE_NOFLAG}{
Default value.
\itemize{
\item{Write JSON minify.}
\item{Report error on inf or nan number.}
\item{Report error on invalid UTF-8 string.}
\item{Do not escape unicode or slash.}
}
}
\item{YYJSON_WRITE_PRETTY}{Write JSON pretty with 4 space indent.}
\item{YYJSON_WRITE_ESCAPE_UNICODE}{Escape unicode as \code{uXXXX}, make the
output ASCII only.}
\item{YYJSON_WRITE_ESCAPE_SLASHES}{Escape '/' as '\/'.}
\item{YYJSON_WRITE_ALLOW_INF_AND_NAN}{Write inf and nan number as 'Infinity'
and 'NaN' literal (non-standard).}
\item{YYJSON_WRITE_INF_AND_NAN_AS_NULL}{Write inf and nan number as null literal.
This flag will override \code{YYJSON_WRITE_ALLOW_INF_AND_NAN} flag.}
\item{YYJSON_WRITE_ALLOW_INVALID_UNICODE}{Allow invalid unicode when encoding
string values (non-standard).
Invalid characters in string value will be copied byte by byte.
If \code{YYJSON_WRITE_ESCAPE_UNICODE} flag is also set, invalid character will be
escaped as \code{U+FFFD} (replacement character).
This flag does not affect the performance of correctly encoded strings.}
\item{YYJSON_WRITE_PRETTY_TWO_SPACES}{Write JSON pretty with 2 space indent.
This flag will override \code{YYJSON_WRITE_PRETTY} flag.}
}
}
\examples{
write_json_str("hello/there", opts = opts_write_json(
  yyjson_write_flag = yyjson_write_flag$YYJSON_WRITE_ESCAPE_SLASHES
))
}
\keyword{datasets}
