% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batsmanRunsVsStrikeRate.R
\name{batsmanRunsVsStrikeRate}
\alias{batsmanRunsVsStrikeRate}
\title{Batsman runs versus strike rate}
\usage{
batsmanRunsVsStrikeRate(df, name= "A Late Cut",dateRange,staticIntv=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of batsman}

\item{dateRange}{Date interval to consider}

\item{staticIntv}{Static or interactive -staticIntv =1 (static plot) &  staticIntv =2 (interactive  plot)}
}
\value{
None
}
\description{
This function plots the runs scored by the batsman  and the runs scored
by the batsman. A loess line is fitted over the points
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the data frame for Kohli
kohli <- getBatsmanDetails(team="India",name="Kohli",dir=pathToFile)
batsmanRunsVsStrikeRate(kohli,"Kohli",dateRange)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{batsmanDismissals}}\cr
\code{\link{batsmanRunsVsDeliveries}}\cr
\code{\link{batsmanRunsVsStrikeRate}}\cr
\code{\link{batsmanRunsPredict}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
