% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{shadow}
\alias{shadow}
\title{Shadows}
\usage{
shadow(tag, size = "regular")
}
\arguments{
\item{tag}{A tag element.}

\item{size}{One of \code{"none"}, \code{"small"}, \code{"regular"}, or \code{"large"} specifying
the amount of shadow added, defaults to \code{"regular"}.}
}
\description{
The \code{shadow} utility applies a shadow to a tag element. Elements with a
shadow may appear to pop off the page. The material design set of components,
used on Android and for Google applications, commonly uses shadowing.
Although \code{"none"} is an allowed \code{size}, most elements do not have a shadow by
default.
}
\examples{

### Styling a navbar

div(
  navbar(brand = "Navbar") \%>\%
    background("cyan") \%>\%
    shadow("small") \%>\%
    margin(bottom = 3),
  p(
    "Cras mattis consectetur purus sit amet fermentum. Donec sed ",
    "odio dui. Lorem ipsum dolor sit amet, consectetur adipiscing ",
    "elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam ",
    "venenatis vestibulum."
  )
)

### Different shadows

div(
  lapply(
    c("small", "regular", "large"),
    shadow,
    tag = div() \%>\%
      padding(5) \%>\%
      margin(2)
  )
) \%>\%
  display("flex")

}
\seealso{
Other design utilities: 
\code{\link{active}()},
\code{\link{affix}()},
\code{\link{background}()},
\code{\link{border}()},
\code{\link{display}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{width}()}
}
\concept{design utilities}
