% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{checkboxInput}
\alias{checkboxInput}
\alias{updateCheckboxInput}
\alias{switchInput}
\alias{updateSwitchInput}
\title{Checkbox and switch inputs}
\usage{
checkboxInput(id, choices = NULL, values = choices, selected = NULL,
  ..., inline = FALSE)

updateCheckboxInput(id, choices = NULL, values = choices,
  selected = NULL, inline = FALSE, enable = NULL, disable = NULL,
  valid = NULL, invalid = NULL, session = getDefaultReactiveDomain())

switchInput(id, choices, values = choices, selected = NULL, ...)

updateSwitchInput(id, choices = NULL, values = choices,
  selected = NULL, enable = NULL, disable = NULL, valid = NULL,
  invalid = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character string or vector specifying a label or labels for
the checkbox or checkbar.}

\item{values}{A character string or vector specifying values for the
checkbox or checkbar input, defaults to \code{choice} or \code{values}, respectively.}

\item{selected}{One or more of \code{values} specifying which choices are
selected by default, defaults to \code{NULL}, in which case no choices are
initially selected.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{inline}{One of \code{TRUE} or \code{FALSE} specifying if the checkbox input
choices render inline or stacked, defaults to \code{FALSE}, in which case the
choices are stacked.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{valid}{A character string specifying a message to the user indicating
how the input's value is valid, defaults to \code{NULL.}}

\item{invalid}{A character string specifying a message to the user
indicating how the input's value is invalid, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
Reactive checkbox and checkbar inputs. Users may select one or more choices.
The checkbox input appears as a standard checkbox or set of checkboxes. When
a checkbox input has no selected choices the reactive value is \code{NULL}. Switch
inputs differ from checkboxes only in appearance.
}
\examples{

### One option

checkboxInput(
  id = "checkbox1",
  choices = "Choice 1",
  selected = "Choice 1"
)

### Multiple options

checkboxInput(
  id = "checkbox2",
  choices = c("Choice 1", "Choice 2")
)

### Inline checkbox

checkboxInput(
  id = "checkbox3",
  choices = c("Choice 1", "Choice 2", "Choice 3"),
  inline = TRUE
)

### Switches

switchInput(
  id = "switch1",
  choices = paste("Switch choice", 1:3),
  selected = "Switch choice 3"
) \%>\%
  active("indigo")

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{chipInput}}, \code{\link{fileInput}},
  \code{\link{formInput}}, \code{\link{listGroupInput}},
  \code{\link{menuInput}}, \code{\link{navInput}},
  \code{\link{radioInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
