% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radio.R
\name{radioInput}
\alias{radioInput}
\alias{updateRadioInput}
\title{Radio inputs}
\usage{
radioInput(id, choices = NULL, values = choices,
  selected = values[[1]], ..., inline = FALSE)

updateRadioInput(id, choices = NULL, values = choices,
  selected = NULL, inline = FALSE, enable = NULL, disable = NULL,
  valid = NULL, invalid = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector or list of tag elements specifying the
input's choices.}

\item{values}{A character vector, list of character strings, vector of values
to coerce to character strings, or list of values to coerce to character
strings specifying the values of the radio input's choices, defaults to
\code{choices}.}

\item{selected}{One of \code{values} indicating the default selected value of the
radio input, defaults to \code{NULL}, in which case the first choice is
selected by default.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{inline}{If \code{TRUE}, the radio input renders inline, defaults to \code{FALSE},
in which case the radio controls render on separate lines.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{valid}{A character string specifying a message to the user indicating
how the input's value is valid, defaults to \code{NULL.}}

\item{invalid}{A character string specifying a message to the user
indicating how the input's value is invalid, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A stylized radio input. A reactive input with multiple choices where only one
choice and value at most may be selected.
}
\examples{

### Out-of-the-box radios

radioInput(
  id = "radio1",
  choices = c(
    "Vehicula adipiscing mattis",
    "Magna nullam",
    "Aenean venenatis",
    "Tristique quam porta"
  )
)

### Inline radio input

radioInput(
  id = "radio2",
  choices = c(
    "Choice 1",
    "Choice 2",
    "Choice 3"
  ),
  inline = TRUE  # <-
)

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{listGroupInput}}, \code{\link{menuInput}},
  \code{\link{navInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
