% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_package.R
\name{new_package}
\alias{new_package}
\alias{np}
\title{Create a package skeleton}
\usage{
new_package(
  name = "mypackage",
  dir = ".",
  firstname = getOption("ympes.firstname", "Joe"),
  surname = getOption("ympes.surname", "Bloggs"),
  email = getOption("ympes.email", "Joe.Bloggs@missing.com"),
  orcid = getOption("ympes.orcid", default = NULL),
  enter = TRUE
)

np(
  name = "mypackage",
  dir = ".",
  firstname = getOption("ympes.firstname", "Joe"),
  surname = getOption("ympes.surname", "Bloggs"),
  email = getOption("ympes.email", "Joe.Bloggs@missing.com"),
  orcid = getOption("ympes.orcid", default = NULL),
  enter = TRUE
)
}
\arguments{
\item{name}{\verb{[character]}

Package name}

\item{dir}{\verb{[character]}

Directory to start in.}

\item{firstname}{\verb{[character]}

Maintainer's firstname.}

\item{surname}{\verb{[character]}

Maintainer's surname.}

\item{email}{\verb{[character]}

Maintainer's email address.}

\item{orcid}{\verb{[character]}

Maintainer's ORCID.}

\item{enter}{\verb{[bool]}

Should you move in to the package directory after creation.

Only applicable in interactive sessions.}
}
\value{
Created directory (invisibly)
}
\description{
\code{new_package()} create a package skeleton based on my preferred folder
structure.
}
\examples{

# usage without entering directory
p <- new_package("my_package_1", dir = tempdir(), enter = FALSE)

# clean up
unlink(p, recursive = TRUE)

}
