% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_rmarkdown.R
\name{yml_resource_files}
\alias{yml_resource_files}
\title{Add external resource files to R Markdown document}
\usage{
yml_resource_files(.yml, resource_files)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{resource_files}{A path to a file, directory, or a wildcard pattern
(such as "data/*.csv")}
}
\value{
a \code{yml} object
}
\description{
The \code{resource_files} field specifies a character vectors of paths to external
resources to include in the output, e.g. files that are necessary for
rendering. These files are handled with
\code{rmarkdown::find_external_resources()}.
}
\examples{

yml() \%>\%
  yml_resource_files(c("data/mydata.csv", "images/figure.png"))
}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
