% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_citations.R
\name{yml_citations}
\alias{yml_citations}
\title{Set citation-related YAML options}
\usage{
yml_citations(.yml, bibliography = yml_blank(), csl = yml_blank(),
  citation_abbreviations = yml_blank(), link_citations = yml_blank(),
  nocite = yml_blank(), suppress_bibliography = yml_blank())
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \code{yml_*()} function}

\item{bibliography}{a path to a bibliography file, such as a .bib file}

\item{csl}{a path to a Citation Style Language (CSL) file. CSL files are used
to specify the citation style; see the \href{https://github.com/citation-style-language/styles}{CSL repository} for the CSL
files of dozens of journals.}

\item{citation_abbreviations}{Path to a CSL abbreviations JSON file. See the
\href{http://manpages.ubuntu.com/manpages/xenial/man1/pandoc-citeproc.1.html}{pandoc-citeproc documentation}.
Note that the actual YAML field is \code{citation-abbreviations}.}

\item{link_citations}{Logical. Add citations hyperlinks to the corresponding
bibliography entries?  Note that the actual YAML field is \code{link-citations}.}

\item{nocite}{Citation IDs (\code{"@item1"}) to include in the bibliography even if
they are not cited in the document. Including the wildcard pattern \code{"@*"}
will include all citations in the bibliography regardless of if they're
cited in the document.}

\item{suppress_bibliography}{Logical. Suppress bibliography?}
}
\value{
a \code{yml} object
}
\description{
\code{yml_citations()} sets citation-related YAML fields, such as specifying a
bibliography file or style. For controlling the citation engine in PDF
documents, see the \code{citation_package} argument in
\code{rmarkdown::pdf_document()}.
}
\examples{

yml() \%>\%
  yml_citations(bibliography = "references.bib", csl = "aje.csl")

}
\seealso{
Other yml: \code{\link{asis_yaml_output}},
  \code{\link{bib2yml}}, \code{\link{draw_yml_tree}},
  \code{\link{has_field}}, \code{\link{read_json}},
  \code{\link{use_yml_defaults}},
  \code{\link{use_yml_file}}, \code{\link{use_yml}},
  \code{\link{yml_author}},
  \code{\link{yml_blogdown_opts}},
  \code{\link{yml_bookdown_opts}}, \code{\link{yml_clean}},
  \code{\link{yml_distill_opts}},
  \code{\link{yml_latex_opts}}, \code{\link{yml_output}},
  \code{\link{yml_pagedown_opts}},
  \code{\link{yml_params}}, \code{\link{yml_pkgdown}},
  \code{\link{yml_reference}}, \code{\link{yml_replace}},
  \code{\link{yml_resource_files}},
  \code{\link{yml_rsconnect_email}},
  \code{\link{yml_rticles_opts}},
  \code{\link{yml_runtime}}, \code{\link{yml_site_opts}},
  \code{\link{yml_toc}}, \code{\link{yml_vignette}}

Other citations: \code{\link{bib2yml}},
  \code{\link{yml_reference}}
}
\concept{citations}
\concept{yml}
