% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{accuracy}
\alias{accuracy}
\alias{accuracy.data.frame}
\alias{accuracy.table}
\alias{accuracy.matrix}
\title{Classification Metrics on Predited Classes}
\usage{
accuracy(data, ...)

\method{accuracy}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

\method{accuracy}{table}(data, ...)

\method{accuracy}{matrix}(data, ...)
}
\arguments{
\item{data}{For the default functions, a factor containing the
discrete measurements. For the \code{table} or \code{matrix}
functions, a table or matrix object, respectively, where the
true class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should an unquoted column name although
this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{estimate}{The column identifier for the predicted class
results (that is also factor). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds}
}
\description{
General metrics for classification models
}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}
}
\author{
Max Kuhn
}
\keyword{manip}
