% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{explicit_guide.dvec}
\alias{explicit_guide.dvec}
\title{Coerce Decorated Vector Guide to Something More Explicit}
\usage{
\method{explicit_guide}{dvec}(
  x,
  ...,
  overwrite = getOption("explicit_guide_overwrite", TRUE),
  simplify = getOption("explicit_guide_simplify", TRUE)
)
}
\arguments{
\item{x}{dvec}

\item{...}{named arguments passed to \code{\link{as_yamlet}}, \code{\link{explicit_guide}}, and \code{\link{decorate}}; un-named arguments ignored}

\item{overwrite}{passed as TRUE}

\item{simplify}{whether to remove guide attribute}
}
\value{
dvec
}
\description{
Coerces dvec 'guide' attribute to something more explicit.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream.
}
\examples{
library(magrittr)
x <- data.frame(
 ID = as_dvec(1),
 CONC = as_dvec(1),
 RACE = as_dvec(1),
 SEX = as_dvec(1),
 DATE = as_dvec(1)
)
x \%<>\% modify(ID, label = 'subject identifier')
x \%<>\% modify(CONC, label = 'concentration', guide = 'ng/mL')
x \%<>\% modify(RACE, label = 'race', guide = list(white = 0, black = 1, asian = 2))
x \%<>\% modify(SEX, label = 'sex', guide = list(female = 0, male = 1))
x \%<>\% modify(DATE, label  = 'date', guide = '\%Y-\%m-\%d')
x \%>\% decorations
x \%>\% explicit_guide \%>\% decorations
x \%>\% explicit_guide(DATE) \%>\% decorations # limit scope
x \%$\% DATE \%>\% explicit_guide
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{explicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide}()},
\code{\link{infer_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
