% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_table.R
\name{io_table}
\alias{io_table}
\title{Import and Export Documented Tables}
\usage{
io_table(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
See methods.
}
\description{
Imports or exports documented tables.  Generic, with methods
that extend \code{\link{read.table}} and \code{\link{write.table}}.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
out <- file.path(tempdir(), 'out.tab')
foo <- io_table(x, out)
identical(out, foo)
y <- io_table(foo, as.is = TRUE)
attr(x, 'source') <- NULL
rownames(x) <- NULL
rownames(y) <- NULL
identical(x, y) # lossless 'round-trip'
}
\seealso{
Other io: 
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_csv}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()}

Other interface: 
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_csv}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()},
\code{\link{read_yamlet}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
