% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xd_index.R
\name{xd_index}
\alias{xd_index}
\title{xd_index}
\usage{
xd_index(df, cat, id, cit, dlm = ";")
}
\arguments{
\item{df}{A data frame object containing bibliometric data}

\item{cat}{Column in df containing categories}

\item{id}{Column in df containing IDs}

\item{cit}{Column in df containing citations}

\item{dlm}{Delimiter in cat. Default delimiter set to ";"}
}
\value{
xd-index value for institution
}
\description{
Compute xd-index for an institution from an edge list
}
\examples{
dat1 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                   keywords = c("a; b; c", "b; d", "c", "d", "e; g", "f", "g"),
                   id = c("abc123", "bcd234", "def345", "efg456", "fgh567", "ghi678", "hij789"),
                   categories = c("a; d; e", "b", "c", "d; g", "e", "f", "g"))
xd_index(df = dat1, cat = "categories", id = "id", cit = "citations", dlm = ";")

dat2 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                  keywords = c("a/ b/ c", "b/ d", "c", "d", "e/ g", "f", "g"),
                  id = c("123", "234", "345", "456", "567", "678", "789"),
                  categories = c("a/ d/ e", "b", "c", "d/ g", "e", "f", "g"))
xd_index(df = dat2, cat = "categories", id = "id", cit = "citations", dlm = "/")

dat3 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                  keywords = c("a, b, c", "b, d", "c", "d", "e, g", "f", "g"),
                  id = c(123, 234, 345, 456, 567, 678, 789),
                  categories = c("a: d: e", "b", "c", "d: g", "e", "f", "g"))
xd_index(df = dat3, cat = "categories", id = "id", cit = "citations", dlm = ":")
}
