% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgam.plots.R
\name{xp.inc.stab.cov}
\alias{xp.inc.stab.cov}
\title{Inclusion stability plot
  
  A plot of the inclusion frequency of covariates vs bootgam/bootscm
  iteration number. This plot can be used to evaluate whether sufficient
  iterations have been performed.}
\usage{
xp.inc.stab.cov(
  bootgam.obj = NULL,
  boot.type = NULL,
  main = NULL,
  normalize = TRUE,
  split.plots = FALSE,
  xlb = "Bootstrap replicate number",
  ylb = "Difference of estimate with final",
  ...
)
}
\arguments{
\item{bootgam.obj}{The bootgam or bootscm object.}

\item{boot.type}{Either "bootgam" or "bootscm". Default is NULL, 
which means the user will be asked to make a choice.}

\item{main}{Plot title}

\item{normalize}{Should the plot be normalized?}

\item{split.plots}{Should the plots be split?}

\item{xlb}{The label for the x-axis.}

\item{ylb}{The label for the y-axis.}

\item{...}{Additional plotting parameters}
}
\value{
A lattice plot object is returned.
}
\description{
Inclusion stability plot
  
  A plot of the inclusion frequency of covariates vs bootgam/bootscm
  iteration number. This plot can be used to evaluate whether sufficient
  iterations have been performed.
}
\seealso{
Other bootgam: 
\code{\link{xp.daic.npar.plot}()},
\code{\link{xp.dofv.npar.plot}()},
\code{\link{xp.inc.cond.stab.cov}()},
\code{\link{xp.inc.ind.cond.stab.cov}()},
\code{\link{xp.incl.index.cov.ind}()},
\code{\link{xp.incl.index.cov}()}

Other bootscm: 
\code{\link{bootscm.import}()},
\code{\link{xp.daic.npar.plot}()},
\code{\link{xp.dofv.npar.plot}()},
\code{\link{xp.inc.cond.stab.cov}()},
\code{\link{xp.inc.ind.cond.stab.cov}()},
\code{\link{xp.incl.index.cov.ind}()},
\code{\link{xp.incl.index.cov}()}
}
\author{
Ron Keizer
}
\concept{bootgam}
\concept{bootscm}
