% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlabel.R
\name{xlabel}
\alias{xlabel}
\alias{xlabel<-}
\title{Extract and set labels for Xpose data items.}
\usage{
xlabel(x, object)

xlabel(object) <- value
}
\arguments{
\item{x}{Name of the variable to assign a label to.}

\item{object}{An \code{xpose.data} object.}

\item{value}{A two element vector of which the first element is the name of
the variable and the second the label}
}
\value{
The label of the specified column.
}
\description{
This function extracts and sets label definitions in Xpose data objects.
}
\details{
\code{x} should be a string exactly matching the name of a column in the
data.frame in the Data slot of an xpose.data object. The name of columns
defined through xpose variable definitions (see \code{\link{xpose.data}})
can be extracted using the \code{xvardef} function and to be used in the
\code{xlabel} function, e.g. \code{xlabel(xvardef("dv",object),object)},
which would give the label for the \code{dv} variable.
}
\section{Functions}{
\itemize{
\item \code{xlabel<-}: sets label definitions in Xpose data objects.  assigned value should be a two-element vector 
of which the first element is the name of
the variable and the second the label
}}

\examples{

xpdb <- simpraz.xpdb

## Display label for dependent variable in the Xpose data object
xlabel("DV", xpdb)

## Set label for dependent variable
xlabel(xpdb) <- c("DV", "Concentration (mg/L)")
xlabel("DV", xpdb) # how has this chnaged?
}
\seealso{
\code{\link{xpose.prefs-class}}, \code{\link{xvardef}}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson
}
\concept{data functions}
\keyword{methods}
