% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.dv.vs.idv.sb.R
\name{cat.dv.vs.idv.sb}
\alias{cat.dv.vs.idv.sb}
\title{Categorical observations vs. independent variable using stacked bars.}
\usage{
cat.dv.vs.idv.sb(
  object,
  dv = xvardef("dv", object),
  idv = xvardef("idv", object),
  by = NULL,
  groups = dv,
  force.by.factor = FALSE,
  recur = F,
  xlb = idv,
  ylb = "Proportion",
  subset = NULL,
  vary.width = T,
  level.to.plot = NULL,
  refactor.levels = TRUE,
  main = xpose.create.title.text(idv, dv, "Proportions of", object, subset = subset,
    ...),
  stack = TRUE,
  horizontal = FALSE,
  strip = function(...) strip.default(..., strip.names = c(TRUE, TRUE)),
  scales = list(),
  inclZeroWRES = TRUE,
  onlyfirst = FALSE,
  samp = NULL,
  aspect = object@Prefs@Graph.prefs$aspect,
  auto.key = "Default",
  mirror = FALSE,
  mirror.aspect = "fill",
  pass.plot.list = FALSE,
  x.cex = NULL,
  y.cex = NULL,
  main.cex = NULL,
  mirror.internal = list(strip.missing = missing(strip)),
  ...
)
}
\arguments{
\item{object}{Xpose data object.}

\item{dv}{The dependent variable (e.g. \code{"DV"} or \code{"CP"}.)}

\item{idv}{The independent variable (e.g. \code{"TIME"}.)}

\item{by}{Conditioning variable}

\item{groups}{How we should group values in each conditional plot.}

\item{force.by.factor}{Should we force the data to be treated as factors?}

\item{recur}{Not used.}

\item{xlb}{A string giving the label for the x-axis. \code{NULL} if none.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{subset}{Subset of data.}

\item{vary.width}{Should we vary the width of the bars to match amount of
information?}

\item{level.to.plot}{Which levels of the DV to plot.}

\item{refactor.levels}{Should we refactor the levels?}

\item{main}{The title of the plot.}

\item{stack}{Should we stack the bars?}

\item{horizontal}{Should the bars be horizontal?}

\item{strip}{Defining how the strips should appear in the conditioning
plots.}

\item{scales}{Scales argument to \code{\link[lattice]{xyplot}}.}

\item{inclZeroWRES}{Include rows with WRES=0?}

\item{onlyfirst}{Only include first data point for each individual?}

\item{samp}{Sample to use in mirror plot (a number).}

\item{aspect}{Aspect argument to \code{\link[lattice]{xyplot}}.}

\item{auto.key}{Make a legend.}

\item{mirror}{Mirror can be \code{FALSE}, \code{TRUE}, 1 or 3.}

\item{mirror.aspect}{Aspect for mirror.}

\item{pass.plot.list}{Should the plot list be passed back to user?}

\item{x.cex}{Size of x axis label.}

\item{y.cex}{Size of Y axis label.}

\item{main.cex}{Size of Title.}

\item{mirror.internal}{Internal stuff.}

\item{\dots}{Other arguments passed to function.}
}
\description{
Categorical observations vs. independent variable using stacked bars.
}
\examples{

\dontrun{
## read in table files
runno <- 45
xpdb <- xpose.data(runno)

## make some stacked bar plots
cat.dv.vs.idv.sb(xpdb,idv=NULL,stack=F)
cat.dv.vs.idv.sb(xpdb,idv=NULL,stack=F,by="DOSE")
cat.dv.vs.idv.sb(xpdb,idv="DOSE")
cat.dv.vs.idv.sb(xpdb,idv=NULL,stack=F,by="TIME")
cat.dv.vs.idv.sb(xpdb,idv="TIME")
cat.dv.vs.idv.sb(xpdb,idv="CAVH")
cat.dv.vs.idv.sb(xpdb,idv="TIME",by="DOSE",scales=list(x=list(rot=45)))

## make some mirror plots
cat.dv.vs.idv.sb(xpdb,idv="DOSE",mirror=1)
cat.dv.vs.idv.sb(xpdb,idv="CAVH",mirror=1,auto.key=F)
}

}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{specific functions}
\keyword{methods}
