% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.model.comp.R
\name{basic.model.comp}
\alias{basic.model.comp}
\title{Basic model comparison plots, for Xpose 4}
\usage{
basic.model.comp(
  object,
  object.ref = NULL,
  onlyfirst = FALSE,
  inclZeroWRES = FALSE,
  subset = xsubset(object),
  main = "Default",
  force.wres = FALSE,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{object.ref}{An xpose.data object. If not supplied, the user will be
prompted.}

\item{onlyfirst}{Logical value indicating whether only the first row per
individual is included in the plot.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is
included in the plot. The default is TRUE.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{force.wres}{Force function to use WRES?}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of plots comprising comparisons of PRED, IPRED, WRES
(or CWRES) and IWRES for the two specified runs.
}
\description{
This creates a stack of four plots, comparing PRED, IPRED, WRES (or CWRES),
and IWRES estimates for the two specified model fits.
}
\details{
Four basic model comparison plots are displayed in sequence.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for runs
## 5 and 6 in the current working directory
xpdb5 <- xpose.data(5)
xpdb6 <- xpose.data(6)

## A vanilla plot, without prompts
basic.model.comp(xpdb5, xpdb6, prompt = FALSE)

## Custom colours and symbols, no user IDs
basic.model.comp.cwres(xpdb5, xpdb6, cex=0.6, pch=8, col=1, ids=NULL)
}


}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{compute.cwres}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
