% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runsum.R
\name{runsum}
\alias{runsum}
\title{Print run summary in Xpose 4}
\usage{
runsum(
  object,
  dir = "",
  modfile = paste(dir, "run", object@Runno, ".mod", sep = ""),
  listfile = paste(dir, "run", object@Runno, ".lst", sep = ""),
  main = NULL,
  subset = xsubset(object),
  show.plots = TRUE,
  txt.cex = 0.7,
  txt.font = 1,
  show.ids = FALSE,
  param.table = TRUE,
  txt.columns = 2,
  force.wres = FALSE,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{dir}{The directory to look for the model and output file of a NONMEM
run.}

\item{modfile}{The name of the NONMEM control stream associated with the
current run.}

\item{listfile}{The name of the NONMEM output file associated with the
current run.}

\item{main}{A string giving the main heading. \code{NULL} if none.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{show.plots}{Logical indicating if GOF plots should be shown in the run
summary.}

\item{txt.cex}{Number indicating the size of the txt in the run summary.}

\item{txt.font}{Font of the text in the run summary.}

\item{show.ids}{Logical indicating if IDs should be plotted in the plots for
the run summary.}

\item{param.table}{Logical indicating if the parameter table should be shown
in the run summary.}

\item{txt.columns}{The number of text columns in the run summary.}

\item{force.wres}{Plot the WRES even if other residuals are available.}

\item{\dots}{Other arguments passed to the various functions.}
}
\value{
A compound plot containing an Xpose run summary is created.
}
\description{
Function to build Xpose run summaries.
}
\examples{
od = setwd(tempdir()) # move to a temp directory
(cur.files <- dir()) # current files in temp directory

simprazExample(overwrite=TRUE) # write files
(new.files <- dir()[!(dir() \%in\% cur.files)])  # what files are new here?

xpdb <- xpose.data(1)
runsum(xpdb)


file.remove(new.files) # remove these files
setwd(od)  # restore working directory


}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres_wres_vs_x}},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Niclas Jonsson and Andrew Hooker
}
\concept{specific functions}
\keyword{methods}
