% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wres.vs.cov.R
\name{wres.vs.cov}
\alias{wres.vs.cov}
\title{Weighted residuals (WRES) plotted against covariates, for Xpose 4}
\usage{
wres.vs.cov(object, ylb = "WRES", smooth = TRUE, type = "p",
  main = "Default", ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{smooth}{A \code{NULL} value indicates that no superposed line should
be added to the graph. If \code{TRUE} then a smooth of the data will be
superimposed.}

\item{type}{1-character string giving the type of plot desired.  The
following values are possible, for details, see 'plot': '"p"' for points,
'"l"' for lines, '"o"' for over-plotted points and lines, '"b"', '"c"') for
(empty if '"c"') points joined by lines, '"s"' and '"S"' for stair steps and
'"h"' for histogram-like vertical lines.  Finally, '"n"' does not produce
any points or lines.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}} or
\code{link{xpose.plot.histogram}}.}
}
\value{
Returns a stack of xyplots and histograms of CWRES versus
covariates.
}
\description{
This creates a stack of plots of weighted residuals (WRES) plotted against
covariates, and is a specific function in Xpose 4. It is a wrapper
encapsulating arguments to the \code{xpose.plot.default} and
\code{xpose.plot.histogram} functions. Most of the options take their
default values from xpose.data object but may be overridden by supplying
them as arguments.
}
\details{
Weighted residuals (WRES) are plotted against each covariate present, as
specified in \code{object@Prefs@Xvardef$covariates}, creating a stack of
plots.

A wide array of extra options controlling xyplots and histograms are
available. See \code{\link{xpose.plot.default}} and
\code{\link{xpose.plot.histogram}} for details.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## Here we load the example xpose database 
data(simpraz.xpdb)
xpdb <- simpraz.xpdb

## A vanilla plot
wres.vs.cov(xpdb)

## Custom colours and symbols, IDs
wres.vs.cov(xpdb, cex=0.6, pch=3, col=1, ids=TRUE)
}

}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.plot.histogram}}, \code{\link[lattice]{xyplot}},
\code{\link[lattice]{histogram}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\keyword{methods}
