% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.model.comp.R
\name{add.model.comp}
\alias{add.model.comp}
\title{Additional model comparison plots, for Xpose 4}
\usage{
add.model.comp(object, object.ref = NULL, onlyfirst = FALSE,
  inclZeroWRES = FALSE, subset = xsubset(object), main = "Default",
  force.wres = FALSE, ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{object.ref}{An xpose.data object. If not supplied, the user will be
prompted.}

\item{onlyfirst}{Logical value indicating whether only the first row per
individual is included in the plot.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is
included in the plot. The default is TRUE.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{force.wres}{Should we use the WRES in the plots instead of CWRES
(logical \code{TRUE} or \code{FALSE})}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of plots comprising comparisons of absolute values
of PRED, absolute values of IPRED, absolute differences in CWRES (or WRES)
and absolute differences in IWRES for the two specified runs.
}
\description{
This creates a stack of four plots, comparing absolute values of PRED,
absolute values of IPRED, delta CWRES (or WRES) and delta IWRES estimates
for the two specified model fits.
}
\details{
Four model comparison plots are displayed in sequence.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for runs
## 5 and 6 in the current working directory
xpdb5 <- xpose.data(5)
xpdb6 <- xpose.data(6)

## A vanilla plot, without prompts
add.model.comp(xpdb5, xpdb6, prompt = FALSE)

## Custom colours and symbols, no user IDs
add.model.comp(xpdb5, xpdb6, cex=0.6, pch=8, col=1, ids=NULL)
}


}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{compute.cwres}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\keyword{methods}
