% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_edits.R
\name{summarise_xpdb}
\alias{summarise_xpdb}
\alias{group_by.xpose_data}
\alias{ungroup.xpose_data}
\alias{summarise.xpose_data}
\alias{summarize.xpose_data}
\title{Group/ungroup and summarize variables in an xpdb}
\usage{
\method{group_by}{xpose_data}(.data, ..., .problem, .source, .where)

\method{ungroup}{xpose_data}(x, ..., .problem, .source, .where)

\method{summarise}{xpose_data}(.data, ..., .problem, .source, .where)

\method{summarize}{xpose_data}(.data, ..., .problem, .source, .where)
}
\arguments{
\item{.data}{An xpose database object.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.

These arguments are automatically quoted and evaluated in the 
context of the data frame. They support unquoting and splicing. 
See the dplyr vignette("programming") for an introduction to these concepts.}

\item{.problem}{The problem from which the data will be modified}

\item{.source}{The source of the data in the xpdb. Can either be 'data' or an output 
file extension e.g. 'phi'.}

\item{.where}{A vector of element names to be edited in special (e.g. 
\code{.where = c('vpc_dat', 'aggr_obs')} with vpc).}

\item{x}{Same as .data (used for consistency with dplyr functions).}
}
\description{
\code{group_by()} takes an existing table and converts it into a 
grouped table where operations are performed "by group". \code{ungroup()} removes grouping.
\code{summarize()} reduces multiple values down to a single value.
}
\examples{
# Create a distribution plot of Cmax
xpdb_ex_pk \%>\% 
 group_by(ID, SEX, .problem = 1) \%>\% 
 summarize(CMAX = max(DV), .problem = 1) \%>\% 
 ungroup(.problem = 1) \%>\% 
 xplot_distrib(aes(x = CMAX, density_fill = SEX), type = 'dr')
 
}
