% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{xportr_type}
\alias{xportr_type}
\title{Coerce variable type}
\usage{
xportr_type(
  .df,
  metacore,
  domain = NULL,
  verbose = getOption("xportr.type_verbose", "none")
)
}
\arguments{
\item{.df}{An R object with columns that can be coerced}

\item{metacore}{Either a data.frame that has the names of all possible columns
and their types, or a \code{Metacore} object from the \code{Metacore} package. Required
column names are dataset, variables, type}

\item{domain}{Name of the dataset. Ex ADAE/DM. This will be used to subset
the metacore object. If none is passed it is assumed to be the name of the
dataset passed in \code{.df}.}

\item{verbose}{The action the function takes when a variable isn't typed
properly. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
Returns the modified table.
}
\description{
Current assumptions:
columns_meta is a data.frame with names "Variables", "Type"
}
\examples{
metacore <- data.frame(
  dataset = "test",
  variable = c("Subj", "Param", "Val", "NotUsed"),
  type = c("numeric", "character", "numeric", "character")
)

.df <- data.frame(
 Subj = as.character(123, 456, 789),
 Different = c("a", "b", "c"),
 Val = c("1", "2", "3"),
 Param = c("param1", "param2", "param3")
)

df2 <- xportr_type(.df, metacore, "test")
}
