% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmR.R
\name{xmr}
\alias{xmr}
\title{Generate the XMR data for any time-series data.}
\usage{
xmr(df, measure, interval, recalc, reuse, testing, longrun, shortrun)
}
\arguments{
\item{df}{The dataframe containing the time-series data. 
Must be in tidy format.
At least 1 variable for time and one variable for measure.}

\item{measure}{The column containing the measure. Must be in numeric format.}

\item{interval}{The interval you'd like to use to calculate the averages. 
Defaults to 5.}

\item{recalc}{Logical: if you'd like it to recalculate bounds. Defaults to False}

\item{reuse}{Logical: Should points be re-used in calculations? Defaults to False}

\item{testing}{Logical to print test results}

\item{longrun}{Vector of 2 to determine rules for long run. First point is the 'n' of points used to recalculate with, and the second is to determine what qualifies as a long run. Default is c(5,8) which uses the first 5 points of a run of 8 to recalculate the bounds.}

\item{shortrun}{Vector of 2 to determine rules for a short run. The first point is the minimium number of points within the set to qualify a shortrun, and the second is the length of a possible set. Default is c(3,4) which states that 3 of 4 points need to pass the test to be used in a calculation.}
}
\description{
Will be used to calculate XMR data.
}
\examples{
\donttest{
df <- xmr(df, "Measure", recalc = T)
}
\donttest{
df <- xmr(df, "Measure", recalc = T, shortrun = c(3,4), longrun = c(5,8))
}
}
