% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlink_fit.R
\name{xlink_fit}
\alias{xlink_fit}
\title{Genetic association models for X-chromosome SNPs on continuous, binary and survival outcomes}
\usage{
xlink_fit(resp = c(), os = c(), ostime = c(), snps = c(),
  gender = c(), covars = c(), option = c(type = c(), male = c(),
  female = c(), MAF_v = 0), model = c(), data)
}
\arguments{
\item{resp}{Response variable for continuous or binary model fitting.}

\item{os}{Survival indicator, 1 for death, 0 for censoring.}

\item{ostime}{Duration time of survival.}

\item{snps}{SNP name list for model fitting.}

\item{gender}{Gender information must be included in the data. Default setting is male=1 and female=0. If not as default setting, please provide male and female information in the option.}

\item{covars}{Covariates list if needed.}

\item{option}{There are three options. First, type has default 'all', which provides model fitting results for each SNP understanding as 'XCI', 'XCI-E' and 'XCI-S' type respectively. If type is chosen as 'XCI' or 'XCI-E', all the SNPS consider as 'XCI' or 'XCI-E' type in corresponding model. Secondly, if gender is not as default gender setting (male=1,female=0), male and female information should be provided here.The third one, MAF_v is the low bound of the minimum allele frequency, the SNP MAF below this value will not be used in xlink_fit.}

\item{model}{Fitting model. For 'linear', fitting linear model. For 'binary', fitting logistic regression model. For 'survival', fitting survival model.}

\item{data}{Data set.}
}
\value{
It returns estimated parameters, confidence interval and P value for each variable in the chosen model. The baseline and full model maximum likelihood estimation are provided. If type is 'all', best model choice is provided by using AIC as an benchmark.
}
\description{
\code{xlink_fit} returns model fitting results for each SNP with the covariates.
}
\examples{
Covars<-c("Age","Smoking","Treatment")
SNPs<-c("snp_1","snp_2","snp_3")
xlink_fit(os="OS",ostime="OS_time",snps=SNPs,gender="gender",covars=Covars,
          option =list(MAF_v=0.05),model="survival",data = Rdata)
xlink_fit(resp="OS_time",snps=SNPs,gender="gender",option =list(type="XCI",MAF_v=0.05),
          model="linear",data = Rdata)
}
\references{
Xu, Wei, and Meiling Hao. 'A unified partial likelihood approach for X-chromosome association on time-to-event outcomes.' Genetic epidemiology 42.1 (2018): 80-94.
}
\seealso{
\code{\link{lm}{stats}} for linear model, \code{\link{glm}{stats}} for logistic regression model, and \code{\link{coxph}{survival}} for survival model.
}
