% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_output.R
\name{select_output}
\alias{select_output}
\title{Selected results table by P value}
\usage{
select_output(input, pv_thold = 1)
}
\arguments{
\item{input}{Input results from xlink fit.}

\item{pv_thold}{P value threshold for output.}
}
\value{
It returns estimated parameters, confidence interval, P value, MAF and Best model information.
}
\description{
\code{select_output} returns selected SNP information by P value.
}
\examples{
Covars<-c("Age","Smoking","Treatment")
SNPs<-c("snp_1","snp_2","snp_3")
result<-xlink_fit(os="OS",ostime ="OS_time",snps=SNPs,gender ="gender",covars=Covars, 
                  option =list(type="all",MAF_v=0.05), model="survival", data = Rdata)
select_output(input=result,pv_thold=10^-5)
}
\seealso{
\code{\link{xlink_fit}{xlink}} for input results.
}
