\name{xkcdrect}
\alias{xkcdrect}
\title{
Plots rectangles
}
\description{
  This function plots rectangles. 
  }
\usage{
xkcdrect(mapping, data,...)
}

\arguments{
   \item{mapping}{Mapping between variables and aesthetics generated by
  aes. See Details.}
  \item{data}{Dataset used in this layer.}
\item{...}{Optional arguments.}


  %   function to be called.}
  % \item{doitalsoforoptargs}{Logical. See Details.}
  % \item{...}{Other arguments.}
}
\details{
  It plots rectangles. The following aesthetics are required:
 \enumerate{
   \item xmin
   \item ymin
   \item xmax
   \item ymax
 }
 Additionally, you can use the aesthetics of \code{geom_rect},
 \code{geom_path}, and \code{pointssegment}.
 }
\value{
A layer with the rectangles.
}
% \references{
%   fibosworld 2013. Change fonts in ggplot2, and create xkcd style graphs \url{http://fibosworld.wordpress.com/2013/02/17/change-fonts-in-ggplot2-and-create-xkcd-style-graphs/}

%   Various Authors 2012. How can we make xkcd style graphs in R?
%   \url{http://stackoverflow.com/questions/12675147/how-can-we-make-xkcd-style-graphs-in-r}

%   \url{http://simonsoftware.se/other/xkcd.ttf}
%  }
% \author{
% Emilio Torres Manzanera
% }

\seealso{
  \code{\link[ggplot2]{geom_rect}}
}
\examples{
volunteers <- data.frame(year=c(2007:2011),
                         number=c(56470, 56998,59686, 61783, 64251))
p <- ggplot() + xkcdrect(aes(xmin = year,
                             xmax= year +0.3,
                             ymin=number,
                             ymax = number + 3600),
                         volunteers,
                         fill="red", colour="black")
p
}

%\keyword{ manip }