% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.model.dt.tree.R
\name{xgb.model.dt.tree}
\alias{xgb.model.dt.tree}
\title{Parse a boosted tree model text dump}
\usage{
xgb.model.dt.tree(
  feature_names = NULL,
  model = NULL,
  text = NULL,
  trees = NULL,
  use_int_id = FALSE,
  ...
)
}
\arguments{
\item{feature_names}{character vector of feature names. If the model already
contains feature names, those would be used when \code{feature_names=NULL} (default value).
Non-null \code{feature_names} could be provided to override those in the model.}

\item{model}{object of class \code{xgb.Booster}}

\item{text}{\code{character} vector previously generated by the \code{xgb.dump}
function  (where parameter \code{with_stats = TRUE} should have been set).
\code{text} takes precedence over \code{model}.}

\item{trees}{an integer vector of tree indices that should be parsed.
If set to \code{NULL}, all trees of the model are parsed.
It could be useful, e.g., in multiclass classification to get only
the trees of one certain class. IMPORTANT: the tree index in xgboost models
is zero-based (e.g., use \code{trees = 0:4} for first 5 trees).}

\item{use_int_id}{a logical flag indicating whether nodes in columns "Yes", "No", "Missing" should be
represented as integers (when FALSE) or as "Tree-Node" character strings (when FALSE).}

\item{...}{currently not used.}
}
\value{
A \code{data.table} with detailed information about model trees' nodes.

The columns of the \code{data.table} are:

\itemize{
 \item \code{Tree}: integer ID of a tree in a model (zero-based index)
 \item \code{Node}: integer ID of a node in a tree (zero-based index)
 \item \code{ID}: character identifier of a node in a model (only when \code{use_int_id=FALSE})
 \item \code{Feature}: for a branch node, it's a feature id or name (when available);
             for a leaf note, it simply labels it as \code{'Leaf'}
 \item \code{Split}: location of the split for a branch node (split condition is always "less than")
 \item \code{Yes}: ID of the next node when the split condition is met
 \item \code{No}: ID of the next node when the split condition is not met
 \item \code{Missing}: ID of the next node when branch value is missing
 \item \code{Quality}: either the split gain (change in loss) or the leaf value
 \item \code{Cover}: metric related to the number of observation either seen by a split
                     or collected by a leaf during training.
}

When \code{use_int_id=FALSE}, columns "Yes", "No", and "Missing" point to model-wide node identifiers
in the "ID" column. When \code{use_int_id=TRUE}, those columns point to node identifiers from
the corresponding trees in the "Node" column.
}
\description{
Parse a boosted tree model text dump into a \code{data.table} structure.
}
\examples{
# Basic use:

data(agaricus.train, package='xgboost')

bst <- xgboost(data = agaricus.train$data, label = agaricus.train$label, max_depth = 2,
               eta = 1, nthread = 2, nrounds = 2,objective = "binary:logistic")

(dt <- xgb.model.dt.tree(colnames(agaricus.train$data), bst))

# This bst model already has feature_names stored with it, so those would be used when
# feature_names is not set:
(dt <- xgb.model.dt.tree(model = bst))

# How to match feature names of splits that are following a current 'Yes' branch:

merge(dt, dt[, .(ID, Y.Feature=Feature)], by.x='Yes', by.y='ID', all.x=TRUE)[order(Tree,Node)]

}
