% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.plot.tree.R
\name{xgb.plot.tree}
\alias{xgb.plot.tree}
\title{Plot a boosted tree model}
\usage{
xgb.plot.tree(feature_names = NULL, model = NULL, n_first_tree = NULL,
  plot_width = NULL, plot_height = NULL, ...)
}
\arguments{
\item{feature_names}{names of each feature as a \code{character} vector. Can be extracted from a sparse matrix (see example). If model dump already contains feature names, this argument should be \code{NULL}.}

\item{model}{generated by the \code{xgb.train} function. Avoid the creation of a dump file.}

\item{n_first_tree}{limit the plot to the n first trees. If \code{NULL}, all trees of the model are plotted. Performance can be low for huge models.}

\item{plot_width}{the width of the diagram in pixels.}

\item{plot_height}{the height of the diagram in pixels.}

\item{...}{currently not used.}
}
\value{
A \code{DiagrammeR} of the model.
}
\description{
Read a tree model text dump and plot the model.
}
\details{
The content of each node is organised that way:

\itemize{
 \item \code{feature} value;
 \item \code{cover}: the sum of second order gradient of training data classified to the leaf, if it is square loss, this simply corresponds to the number of instances in that branch. Deeper in the tree a node is, lower this metric will be;
 \item \code{gain}: metric the importance of the node in the model.
} 

The function uses \href{http://www.graphviz.org/}{GraphViz} library for that purpose.
}
\examples{
data(agaricus.train, package='xgboost')

bst <- xgboost(data = agaricus.train$data, label = agaricus.train$label, max_depth = 2, 
               eta = 1, nthread = 2, nrounds = 2,objective = "binary:logistic")

xgb.plot.tree(feature_names = colnames(agaricus.train$data), model = bst)

}

