% Generated by roxygen2 (4.0.1): do not edit by hand
\name{xgb.dump}
\alias{xgb.dump}
\title{Save xgboost model to text file}
\usage{
xgb.dump(model, fname, fmap = "")
}
\arguments{
\item{model}{the model object.}

\item{fname}{the name of the binary file.}

\item{fmap}{feature map file representing the type of feature, to make it
       look nice, run demo/demo.R for result and demo/featmap.txt for example
       Format: https://github.com/tqchen/xgboost/wiki/Binary-Classification#dump-model}
}
\description{
Save a xgboost model to text file. Could be parsed later.
}
\examples{
data(iris)
bst <- xgboost(as.matrix(iris[,1:4]),as.numeric(iris[,5]), nrounds = 2)
xgb.dump(bst, 'iris.xgb.model.dump')
}

