% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGeneBenchmark.R
\name{predictSelectTime}
\alias{predictSelectTime}
\title{Predict the time use of a selection method for a popsize.}
\usage{
predictSelectTime(df, method = "Uniform", popsize = 1e+05)
}
\arguments{
\item{df}{Data frame.}

\item{method}{Selection method.}

\item{popsize}{Population size.}
}
\value{
List with
\itemize{
\item
             \code{$model}:  The result of \code{stats::lm}.
\item
             \code{$predict}:  The result of \code{stats::predict}.
}
}
\description{
Predict the time use of a selection method for a popsize.
}
\section{Warning}{


Uses a quadratic regression model.
But the complexities of the functions are of orders
    O(1), O(n), O(n.ln(n)) and O(n^2).
}

\examples{
popsizes<-as.integer(seq(from=100, to=200, length.out=5))
a<-runSelectBenchmarks(popsizes, both=TRUE)
b<-predictSelectTime(a, method="SUS", 155)
summary(b$model)
b$predicted
c<- predictSelectTime(a, method="SUS  C", c(155, 500))
summary(c$model)
c$predicted
}
\seealso{
Other Benchmark Selection Functions: 
\code{\link{runOneBenchmark}()},
\code{\link{runSelectBenchmarks}()},
\code{\link{selectBenchmark}()},
\code{\link{testSelectGene}()}
}
\concept{Benchmark Selection Functions}
