% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPopulation.R
\name{xegaLogEvalsPopulation}
\alias{xegaLogEvalsPopulation}
\title{Combine fitness, generations, and the phentype of the gene.}
\usage{
xegaLogEvalsPopulation(pop, evallog, generation, lF)
}
\arguments{
\item{pop}{Population.}

\item{evallog}{Evaluation log.}

\item{generation}{Generation logged.}

\item{lF}{Local function configuration.}
}
\value{
Update of the evaluation log. 
        The evaluation log is a list of decoded and evaluated genes.
        A list item of the evaluation log has the following 
        elements:
        \itemize{
        \item \code{$generation}:   The generation.
        \item \code{$fit}:          The fitness value.
        \item \code{$phenotype}:    The phenotype of the gene.
        }
}
\description{
Combine fitness, generations, and the phentype of the gene.
}
\examples{
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
logevals<-list()
logevals
logevals<-xegaLogEvalsPopulation(epop10$pop, logevals, 1, lFxegaGaGene)
logevals
}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
