% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicateGene}
\alias{xegaGaReplicateGene}
\title{Replicates a gene.}
\usage{
xegaGaReplicateGene(pop, fit, lF)
}
\arguments{
\item{pop}{Population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A list of one gene.
}
\description{
\code{xegaGaReplicateGene} replicates a gene
             by applying a gene reproduction pipeline 
             which uses crossover and
             mutation. 
             The control flow may have the following steps:
             \itemize{
             \item A gene is selected from the population.
             Check if the crossover operation should be applied.
             (The check is \code{TRUE} with a probability of \code{crossrate}).
             If the check is \code{TRUE}:
             \itemize{
               \item Select a mating gene from the population.
               \item Perform the crossover operation.
               \item Apply mutation with a probability of \code{mutrate}.
               \item Return a list one gene.
                           }
               \item Apply mutation with a probability of \code{mutrate}.
               \item Accept gene. For genetic algorithms: Identity.
               \item Return a list with a single gene.
             }
}
\details{
\code{xegaGaReplicateGene} implements the control flow 
         by a dynamic definition of the operator pipeline depending
         on the random choices for mutation and crossover:
\enumerate{
  \item A gene \code{g} is selected and the boolean variables \code{mut}
        and \code{cross} are set to \code{runif(1)<rate}. 
  \item The local function for the operator pipeline \code{OPpip(g, lF)}
        is defined by the truth values of \code{cross} and \code{mut}:
  \enumerate{      
  \item \code{(cross==FALSE) & (mut==FALSE)}: 
          Identity function. 
  \item \code{(cross==TRUE) & (mut==TRUE)}: 
          Mate selection,  crossover, mutation. 
  \item \code{(cross==TRUE) & (mut==FALSE)}: 
          Mate selection, crossover. 
  \item \code{(cross==FALSE) & (mut==TRUE)}: 
          Mutation. 
  }
  \item  Perform the operator pipeline and accept the result.
  }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicateGene(pop10, fit10, lFxegaGaGene)
}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicate2Gene}()}
}
\concept{Replication}
