% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGalF.R
\docType{data}
\name{lFxegaGaGene}
\alias{lFxegaGaGene}
\title{The local function list lFxegaGaGene.}
\format{
An object of class \code{list} of length 28.
}
\usage{
lFxegaGaGene
}
\description{
We enhance the configurability of our code by introducing 
 a function factory. The  function factory contains
 all the functions that are needed for defining
 local functions in genetic operators. The local function  
 list keeps the signatures of functions (e.g. mutation functions)
 uniform and small. At the same time, variants of functions
 can use different local functions.
}
\details{
We use the local function list for 
   \enumerate{
   \item
      replacing all constants by constant functions.
      
      Rationale: We need one formal argument (the local function list lF)
      and we can dispatch multiple functions. E.g.  \code{lF$verbose()}
  \item    
      dynamically binding a local function with a definition from a
      proper function factory. E.g., the selection methods 
      \code{lf$SelectGene} and \code{SelectMate}.
      
 \item gene representations which require special functions to handle them:
       \code{lf$InitGene}, \code{lF$DecodeGene}, \code{lf$EvalGene}
       \code{lf$ReplicateGene}, ...
      
 }
}
\seealso{
Other Configuration: 
\code{\link{xegaGaCrossoverFactory}()},
\code{\link{xegaGaGeneMapFactory}()},
\code{\link{xegaGaMutationFactory}()},
\code{\link{xegaGaReplicationFactory}()}
}
\concept{Configuration}
\keyword{datasets}
