% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{randomDerivationTree}
\alias{randomDerivationTree}
\title{Generates a random derivation tree.}
\usage{
randomDerivationTree(sym, G, maxdepth = 5, CompleteDT = TRUE)
}
\arguments{
\item{sym}{Non-terminal symbol.}

\item{G}{Grammar.}

\item{maxdepth}{Integer. Maximal depth of the derivation tree.}

\item{CompleteDT}{Boolean. Generate a complete derivation tree? 
Default: TRUE.}
}
\value{
Derivation tree (a nested list).
}
\description{
\code{randomDerivationTree()} 
   generates a random derivation tree.
}
\details{
\code{RandomDerivationTree()} recursively expands 
        non-terminals and builds a depth-bounded derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
b<-randomDerivationTree(g$Start, g, maxdepth=10)
c<-randomDerivationTree(g$Start, g, 2, FALSE)

}
\seealso{
Other Generate Derivation Tree: 
\code{\link{generateDerivationTree}()},
\code{\link{rndsubk}()},
\code{\link{rndsub}()},
\code{\link{substituteSymbol}()}
}
\concept{Generate Derivation Tree}
