% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{extra_styles}
\alias{extra_styles}
\alias{use_extra_styles}
\alias{html_dependency_extra_styles}
\title{Add Extra CSS Styles}
\usage{
use_extra_styles(
  hover_code_line = TRUE,
  mute_unhighlighted_code = TRUE,
  bundle_id = NULL
)

html_dependency_extra_styles(
  hover_code_line = TRUE,
  mute_unhighlighted_code = TRUE,
  bundle_id = NULL
)
}
\arguments{
\item{hover_code_line}{Adds a hover effect for code chunks in your slides.
Adds a floating pointer to the hovered line and makes the line bold.}

\item{mute_unhighlighted_code}{On code chunks with highlights (added with
line-ending \verb{#<<} comments or starting with \code{*}), non-highlighted lines
are muted and the highlighted line is full opacity.}

\item{bundle_id}{Make the CSS bundle unique. Use this if your slides share
a common resource directory and you want to include different CSS extras
in different slides.}
}
\value{
An \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the selected additional styles.
}
\description{
Adds CSS extras to your slides. You can select which extras you wish to add
to your slides.
}
\section{Functions}{
\itemize{
\item \code{use_extra_styles}: Add the extra CSS styles to your slides

\item \code{html_dependency_extra_styles}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the
extra styles dependencies. Most users will want to use \code{use_extra_styles()}.
}}

\examples{
use_extra_styles()

}
