% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_xSub.R
\name{get_xSub}
\alias{get_xSub}
\title{Get xSub file}
\usage{
get_xSub(data_source, country_iso3 = NULL, country_name = NULL, space_unit,
  time_unit, out_dir = tempdir(), write_file = TRUE, write_format = "csv",
  verbose = FALSE)
}
\arguments{
\item{data_source}{Name of data source. See \code{info_xSub()} for full list.}

\item{country_iso3}{Country code (ISO3). See \code{info_xSub()} for full list.}

\item{country_name}{Country name. See \code{info_xSub()} for full list.}

\item{space_unit}{Geographic level of analysis. Character string. Can be one of \code{"adm0"} (country), \code{"adm1"} (province), \code{"adm2"} (district), \code{"priogrid"} (grid cell), \code{"clea"} (electoral constituency). See \code{info_xSub(details=TRUE)} for availability by country.}

\item{time_unit}{Temporal level of analysis. Character string. Can be one of \code{"year"}, \code{"month"}, \code{"week"}, \code{"day"}. See \code{info_xSub(details=TRUE)} for availability by country.}

\item{out_dir}{Path to directory where files will be saved. Character string. Default is R session’s temporary directory, \code{tempdir()}.}

\item{write_file}{Logical. If \code{write_file=TRUE}, selected file will be written to disk, at location specified by \code{out_dir}.}

\item{write_format}{Output file format. Can be one of \code{"csv"} (comma-separated values, default), \code{"R"} (RData format, compatible with R statistical programming language), \code{"STATA"} (dta format, compatible with Stata 14).}

\item{verbose}{Logical. When \code{verbose=TRUE}, file download progress is printed to console.}
}
\description{
This function downloads individual files from \code{www.x-sub.org}. Function produces a data.frame, for the user's choice of data source, country, spatial and temporal units, and (optionally) writes this data.frame to disk, in multiple formats.
}
\examples{
# Check which countries are available for ACLED
info_xSub(data_source="ACLED")

# Download ACLED data for Egypt, at country-year level
my_file <- get_xSub(data_source = "ACLED",country_iso3 = "EGY",
           space_unit = "adm0",time_unit = "year")

# Download ACLED data for Egypt, at district-month level
\dontrun{
my_file <- get_xSub(data_source = "ACLED",country_iso3 = "EGY",
           space_unit = "adm2",time_unit = "month")
}

# With country name instead of ISO3 code
\dontrun{
my_file <- get_xSub(data_source = "ACLED",country_name = "Egypt",
           space_unit = "adm2",time_unit = "month")
}
}
\seealso{
\code{\link{info_xSub}}, \code{\link{get_xSub_multi}}
}
