% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_eqtlSig}
\alias{xQTLquery_eqtlSig}
\title{Download significant eQTL associations of a specified tissue or across all tissues.}
\usage{
xQTLquery_eqtlSig(
  variantName = "",
  genes = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = ""
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{genes}{(character string or a character vector) gene symbols or gencode ids (versioned or unversioned are both supported).}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}
}
\value{
A data.table object.
}
\description{
Download significant eQTL associations of a specified tissue or across all tissues.
}
\examples{
\donttest{
# Query significant eQTL associations with a variant id across all tissues:
xQTLquery_eqtlSig("rs201327123")
xQTLquery_eqtlSig("chr1_14677_G_A_b38")
# Query significant eQTL associations with a variant id in a specified tissue:
xQTLquery_eqtlSig("chr1_14677_G_A_b38",
                    tissueSiteDetail="Skin - Sun Exposed (Lower leg)")

# Query eQTL associations for multiple variants:
varInfo <-  xQTLquery_varPos(chrom="chr1", pos=c(1102708))
xQTLquery_eqtlSig(variantName=varInfo$snpId)

# Query eQTL associations by genes or tissues:
xQTLquery_eqtlSig(genes="ATAD3B")
xQTLquery_eqtlSig(genes=c("TP53", "SLC35E2B"), tissueSiteDetail= "Brain - Cerebellum")
xQTLquery_eqtlSig(genes="ENSG00000141510.16")

# Query eQTL associations with a variant-gene pair:
xQTLquery_eqtlSig(variantName="rs1641513", genes="TP53")
xQTLquery_eqtlSig(variantName="chr1_1667948_A_G_b38",
                     genes="SLC35E2B", tissueSiteDetail="Kidney - Cortex")
}
}
