% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_x3p.R
\name{image_x3p}
\alias{image_x3p}
\title{Plot x3p object as an image}
\usage{
image_x3p(x3p, file = NULL, col = "#cd7f32", size = c(750, 250),
  zoom = 0.35, multiply = 5, ...)
}
\arguments{
\item{x3p}{x3p object}

\item{file}{file name for saving, if file is NULL the opengl device stays open.
The file extension determines the type of output. Possible extensions are png, stl (suitable for 3d printing).}

\item{col}{color specification}

\item{size}{vector of width and height}

\item{zoom}{numeric value indicating the amount of zoom}

\item{multiply}{exaggerate the relief by factor multiply}

\item{...}{not used}
}
\description{
Plot x3p object as an image
}
\examples{
\dontrun{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
image_x3p(logo, file = "logo.png")
}
}
