% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_simulations.R
\name{far_1_S}
\alias{far_1_S}
\title{\code{far_1_S} Simulates an FAR(1,S)-fGARCH(1,1) process with N independent observations, each
 observed discretely at J points on the interval [0,1].}
\usage{
far_1_S(N, J, S, type = "IID", burn_in = 50)
}
\arguments{
\item{N}{the number of fGARCH(1,1) curves to sample.}

\item{J}{the number of points at which each curve is sampled (the resolution of the data).}

\item{S}{the autoregressive operator of the model, between 0 and 1, indicating the level of
conditional heteroscedasticity.}

\item{type}{the assumed model of the error term. The default argument is 'IID', under which
the errors are assumed to be independent and identically distributed. The alternative argument
is 'fGARCH', which will assume that the errors follow an fGARCH(1,1) process.}

\item{burn_in}{the number of initial samples to burn (discard).}
}
\value{
A J x N matrix containing FAR(1,S) functional data in the columns.
}
\description{
\code{far_1_S} Simulates an FAR(1,S)-fGARCH(1,1) process with N independent observations, each
 observed discretely at J points on the interval [0,1].
}
\examples{
f <- far_1_S(100, 50, 0.75)

}
