% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warray.R
\name{warray}
\alias{warray}
\title{Creates an array of wavelet transforms from input timeseries}
\usage{
warray(dat, times, scale.min = 2, scale.max.input = NULL, sigma = 1.05,
  f0 = 1)
}
\arguments{
\item{dat}{A locations (rows) x time (columns) matrix}

\item{times}{A vector of timestep values (e.g. years), spacing 1}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation that will be examined. Note that if this is set too high 
relative to the length of the timeseries it will be truncated.}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope}
}
\value{
\code{warray} returns a list containing: 
\item{wavarray}{locations x time x timescales array of wavelet transforms}
\item{times}{the time steps specified (e.g., years)}
\item{timescales}{the timescales (1/frequency) computed for the wavelet transforms}
}
\description{
Creates an array of wavelet transforms from input timeseries
}
\note{
Important for interpreting the phase: the phases grow through time, i.e., they 
turn anti-clockwise. This function is internal, no error checking.
}
\author{
Lauren Hallett, \email{hallett@uoregon.edu}; Lawrence Sheppard, \email{lwsheppard@ku.edu};
Daniel Reuman, \email{reuman@ku.edu}
}
