% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{wa_cache_dir}
\alias{wa_cache_dir}
\title{Path to writeAlizer's user cache}
\usage{
wa_cache_dir()
}
\value{
Character scalar path.
}
\description{
Returns the directory used to store cached model artifacts. By default this is
a platform-appropriate user cache path from \code{tools::R_user_dir("writeAlizer","cache")}.
If the option \code{writeAlizer.cache_dir} is set to a non-empty string, that
location is used instead. This makes it easy to redirect the cache during tests
or examples (e.g., to \code{tempdir()}).
}
\examples{
# Inspect the cache directory (no side effects)
wa_cache_dir()

\dontshow{
# Safe demo: redirect cache to a temp folder, create a file, then clear it
old <- getOption("writeAlizer.cache_dir"); on.exit(options(writeAlizer.cache_dir = old), add = TRUE)
tmp <- file.path(tempdir(), "wa_cache_demo"); dir.create(tmp, recursive = TRUE, showWarnings = FALSE)
options(writeAlizer.cache_dir = tmp)
writeLines("demo", file.path(wa_cache_dir(), "demo.txt"))
wa_cache_clear(ask = FALSE)
}
}
\seealso{
\code{\link{wa_cache_clear}}
}
