% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_order.R
\name{invert_perm}
\alias{invert_perm}
\title{Invert a permutation.}
\usage{
invert_perm(p)
}
\arguments{
\item{p}{vector of length n containing each of seq_len(n) exactly once.}
}
\value{
vector q such that p[q] == q[p] == seq_len(length(p))
}
\description{
For a permutation p build q such that p[q] == q[p] == seq_len(length(p)).
Please see \url{https://win-vector.com/2017/05/18/on-indexing-operators-and-composition/}
and \url{https://win-vector.com/2017/09/02/permutation-theory-in-action/}.
}
\examples{

p <- c(4, 5, 7, 8, 9, 6, 1, 3, 2, 10)
q <- invert_perm(p)
p[q]
all.equal(p[q], seq_len(length(p)))
q[p]
all.equal(q[p], seq_len(length(p)))

}
