% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namedMapBuilder.R
\name{named_map_builder}
\alias{named_map_builder}
\alias{:=}
\alias{\%:=\%}
\title{Named map builder.}
\usage{
named_map_builder(names, values)

`:=`(names, values)

names \%:=\% values
}
\arguments{
\item{names}{names to set.}

\item{values}{values to assign names to (and return).}
}
\value{
values with names set.
}
\description{
Set names of right-argument to be left-argument, and return right argument.
Called from \code{:=} operator.
}
\examples{


c('a' := '4', 'b' := '5')
# equivalent to: c(a = '4', b = '5')

c('a', 'b') := c('1', '2')
# equivalent to: c(a = '1', b = '2')

# the important example
name <- 'a'
name := '5'
# equivalent to: c('a' = '5')

# fn version:
#  applied when right side is {}
#  or when left side is of class formula.

g <- x~y := { x + 3*y }
g(1,100)

f <- ~x := x^2
f(7)

f <- x := { sqrt(x) }
f(7)

}
\seealso{
\code{\link{lambda}}, \code{\link{defineLambda}}, \code{\link{makeFunction_se}}
}
