% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_formula.R
\name{mk_formula}
\alias{mk_formula}
\title{Construct a formula.}
\usage{
mk_formula(outcome, variables, ..., intercept = TRUE,
  outcome_target = NULL, outcome_comparator = "==", env = baseenv(),
  extra_values = NULL)
}
\arguments{
\item{outcome}{character scalar, name of outcome or dependent variable.}

\item{variables}{character vector, names of input or independent variables.}

\item{...}{not used, force later arguments to bind by name.}

\item{intercept}{logical, if TRUE allow an intercept term.}

\item{outcome_target}{scalar, if not NULL write outcome==outcome_target in formula.}

\item{outcome_comparator}{one of "==", "!=", ">=", "<=", ">", "<", only use of outcome_target is not NULL.}

\item{env}{environment to use in formula (unless extra_values is non empty, then this is a parent environemnt).}

\item{extra_values}{if not empty extra values to be added to a new formula environment containing env.}
}
\value{
a formula object
}
\description{
Safely construct a simple Wilkinson notation formula from the outcome (dependent variable) name
and vector of input (independent variable) names.
}
\details{
Note: outcome and variables
are each intended to be simple variable names or column names (or .). They are not
intended to specify
interactions, I()-terms, transforms, general experessions or other complex formula terms.
Essentially the same effect as \code{\link[stats]{reformulate}}, but trying to avoid the
\code{paste} currently in \code{\link[stats]{reformulate}} by calling \code{\link[stats]{update.formula}}
(which appears to work over terms).
Another reasonable way to do this is just \code{paste(outcome, paste(variables, collapse = " + "), sep = " ~ ")}.

Care must be taken with later arguments to functions like \code{lm()} whose help states:
"All of weights, subset and offset are evaluated in the same way as variables in formula, that is first in data and then in the environment of formula."
Also note \code{env} defaults to \code{baseenv()} to try and minimize refence leaks produced by the environemnt
captured by the formal ending up stored in the resulting model for \code{lm()} and \code{glm()}.  For
behavior closer to \code{as.formula()} please set the \code{env} argument to \code{parent.frame()}.
}
\examples{

f <- mk_formula("mpg", c("cyl", "disp"))
print(f)
(model <- lm(f, mtcars))
format(model$terms)

f <- mk_formula("cyl", c("wt", "gear"), outcome_target = 8, outcome_comparator = ">=")
print(f)
(model <- glm(f, mtcars, family = binomial))
format(model$terms)

}
\seealso{
\code{\link[stats]{reformulate}}, \code{\link[stats]{update.formula}}
}
